IF  EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_REPROCESSAMENTO_CUSTO_EXEC_ALL]') 
						AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PROD_REPROCESSAMENTO_CUSTO_EXEC_ALL]
GO 
GO
--EXEC P_EST_PROD_REPROCESSAMENTO_CUSTO_EXEC_ALL 1,0, 0,12,2015,NULL,0,2
CREATE PROCEDURE P_EST_PROD_REPROCESSAMENTO_CUSTO_EXEC_ALL (@CD_EMP INT=1,
														    @CD_FILIAL_INI AS INT=0, 
														    @CD_FILIAL_FINAL INT=0,
															@MES INT=0,
															@ANO INT=0,
															@DT_PROC DATETIME=NULL,
															@CD_PROD INT=0,
															@IGNORA_ATU INT=0)
AS
	SET NOCOUNT ON
	set deadlock_priority high

	DECLARE @CD_FILIAL INT;
	DECLARE @AGORA DATETIME
	DECLARE @DT_INI DATETIME
	DECLARE @DT_FIM DATETIME
	
	IF  @IGNORA_ATU=1
	BEGIN
		print 'Processamento aplicacao custo desabilitado';
		return;
	END

	IF  @DT_PROC IS NULL
		begin
			IF @ANO IS NULL OR @MES IS NULL
				begin
					SELECT @AGORA=DATEADD(month, -1, GETDATE()), @ANO=YEAR(@AGORA), @MES=MONTH(@AGORA)
					--Verifica bloqueio contábil 
					IF EXISTS(SELECT  TOP 1 CD_EMP
								FROM 
									EST_PROD_INVENTARIO  
								WHERE
									year(DT_REF)  >= @ANO
									and month(DT_REF)>@MES
									AND CD_EMP=@CD_EMP
									AND CD_FILIAL=@CD_FILIAL)
					begin
						print 'Data de processamento com bloqueio. Inventario já registrado para o periodo solicitado. - Time : ' +convert(varchar,getdate(),108);
						RETURN; 
					end 
				else
					SET @DT_PROC = CONVERT(DATETIME, (CONVERT(VARCHAR, (@ANO*100+@MES)) + '01')) ;
				end
		end
	else
		begin
			--Verifica bloqueio contábil 
			IF EXISTS(SELECT  TOP 1 CD_EMP
						FROM 
							EST_PROD_INVENTARIO  
						WHERE
							DT_REF >=@DT_PROC
							AND CD_EMP=@CD_EMP
							AND CD_FILIAL=@CD_FILIAL)
			begin
				print 'Data de processamento com bloqueio. Inventario já registrado para o periodo solicitado. - Time : ' +convert(varchar,getdate(),108);
				RETURN; 
			end 
		end
	
	DECLARE  CurFiliaisCustoRepro CURSOR FAST_FORWARD 
	FOR 
	SELECT 
		CD_FILIAL
	FROM 
		PRC_FILIAL A
	WHERE 
		A.CD_EMP = @CD_EMP  
		AND A.CD_FILIAL BETWEEN CASE WHEN @CD_FILIAL_INI = 0 THEN A.CD_FILIAL 
						ELSE @CD_FILIAL_INI END 
		AND CASE WHEN @CD_FILIAL_FINAL = 0 THEN  
					CASE WHEN @CD_FILIAL_INI = 0 THEN A.CD_FILIAL 
					ELSE  @CD_FILIAL_INI 
					END 			
			ELSE 
				@CD_FILIAL_FINAL 
			END
		AND A.STS_FILIAL=0
	ORDER BY A.CD_FILIAL;		

		
	
	OPEN CurFiliaisCustoRepro 
	FETCH NEXT FROM CurFiliaisCustoRepro INTO @CD_FILIAL
	WHILE @@FETCH_STATUS=0
	  BEGIN
		PRINT	'  Filial ' + CONVERT(VARCHAR(5), @CD_FILIAL) + 
				' (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...'
		
		IF  @IGNORA_ATU<>2
		begin
			EXEC P_EST_NF_ENT_IT_REPROCESSAR_CUSTO  @MES,@ANO,@CD_FILIAL,0,@DT_PROC,@CD_PROD;
		end	
				
		EXEC P_PDV_VD_IT_REPROCESSAR_CUSTO @MES,@ANO,@CD_FILIAL,0,@DT_PROC,@CD_PROD;
		EXEC P_PDV_VD_IT_DEVOLUCAO_REPROCESSAR_CUSTO  @MES,@ANO,@CD_FILIAL,0,@DT_PROC,@CD_PROD;
		EXEC P_EST_NF_SAI_IT_REPROCESSAR_CUSTO @MES,@ANO,@CD_FILIAL,0,@DT_PROC,@CD_PROD;
		EXEC P_EST_PROD_DETE_IT_REPROCESSAR_CUSTO  @MES,@ANO,@CD_FILIAL,@DT_PROC,@CD_PROD;
		EXEC P_EST_PROD_REQ_TRANSF_LIB_ITENS_REPROCESSAR_CUSTO  @MES,@ANO,@CD_FILIAL,@DT_PROC,@CD_PROD;

		FETCH NEXT FROM CurFiliaisCustoRepro INTO @CD_FILIAL
	  END
	  
	PRINT 'Concluido.'
	CLOSE CurFiliaisCustoRepro
	DEALLOCATE CurFiliaisCustoRepro
	 
